const translations = {
    "en-US": {
        "Add to Personal Dashboard": "Add to Personal Dashboard",
        "Visualize": "Visualize",
        "Share": "Share",
        "Modify": "Modify",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests",
        "Remove X-Axis Label": "Remove X-Axis Label",
        "Remove Y-Axis Label": "Remove Y-Axis Label",
        "Hide Values On Chart": "Hide Values On Chart",
        "Rotate Labels 45°": "Rotate Labels 45°",
        "Hi! How can I help?": "Hi! How can I help?",
        "Mark as Bad Response": "Mark as Bad Response",
        "Copied to clipboard.": "Copied to clipboard.",
        "Failed to copy to clipboard": "Failed to copy to clipboard",
        "Save failed!": "Save failed!",
        "Saved.": "Saved.",
        "Saved. Refresh the page for the changes to take effect.": "Saved. Refresh the page for the changes to take effect.",
        "Session Deletion Failed!": "Session Deletion Failed!",
        "Tab Creation Failed!": "Tab Creation Failed!",
        "Tab Created Successfully.": "Tab Created Successfully.",
        "Failed to load the dashboard!": "Failed to load the dashboard!",
        "Failed to generate PDF": "Failed to generate PDF",
        "Sync completed.": "Sync completed.",
        "Refresh completed.": "Refresh completed.",
        "Generating the summary. Please wait...": "Generating the summary.<br>Please wait...",
        "Unexpected error while exporting the summary.": "Unexpected error while exporting the summary.",
        "Technical Details": "Technical Details",
        "Copy": "Copy",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.",
    },
    "fr-CA": {
        "Add to Personal Dashboard": "Ajouter au tableau de bord personnel",
        "Visualize": "Visualiser",
        "Share": "Partager",
        "Modify": "Modifier",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "Ajouter la requête et le SQL généré comme nouveau cas de test aux tests de traduction Text-to-SQL",
        "Remove X-Axis Label": "Supprimer l'étiquette de l'axe des X",
        "Remove Y-Axis Label": "Supprimer l'étiquette de l'axe des Y",
        "Hide Values On Chart": "Masquer les valeurs sur le graphique",
        "Rotate Labels 45°": "Faire pivoter les étiquettes de 45°",
        "Hi! How can I help?": "Salut! Comment puis-je vous aider?",
        "Mark as Bad Response": "Marquer comme mauvaise réponse",
        "Copied to clipboard.": "Copié dans le presse-papiers.",
        "Failed to copy to clipboard": "Échec de la copie dans le presse-papiers",
        "Save failed!": "Échec de l'enregistrement!",
        "Saved.": "Enregistré.",
        "Saved. Refresh the page for the changes to take effect.": "Enregistré. Actualisez la page pour que les modifications prennent effet.",
        "Session Deletion Failed!": "Échec de la suppression de la session!",
        "Tab Creation Failed!": "Échec de la création de l'onglet!",
        "Tab Created Successfully.": "Onglet créé avec succès.",
        "Failed to load the dashboard!": "Échec du chargement du tableau de bord!",
        "Failed to generate PDF": "Échec de la génération du PDF",
        "Sync completed.": "Synchronisation terminée.",
        "Refresh completed.": "Rafraîchissement terminé.",
        "Generating the summary. Please wait...": "Génération du résumé. Veuillez patienter...",
        "Unexpected error while exporting the summary.": "Erreur inattendue lors de l'exportation du résumé.",
        "Technical Details": "Détails techniques",
        "Copy": "Copier",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "Si votre prochaine question porte sur un sujet différent, pour de meilleurs résultats, commencez une nouvelle discussion en cliquant sur l'icône plus en haut.",
    },
    "fr-FR": {
        "Add to Personal Dashboard": "Ajouter au tableau de bord personnel",
        "Visualize": "Visualiser",
        "Share": "Partager",
        "Modify": "Modifier",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "Ajouter la requête et le SQL généré comme nouveau cas de test aux tests de traduction Text-to-SQL",
        "Remove X-Axis Label": "Supprimer l'étiquette de l'axe des X",
        "Remove Y-Axis Label": "Supprimer l'étiquette de l'axe des Y",
        "Hide Values On Chart": "Masquer les valeurs sur le graphique",
        "Rotate Labels 45°": "Faire pivoter les étiquettes de 45°",
        "Hi! How can I help?": "Salut! Comment puis-je vous aider?",
        "Mark as Bad Response": "Marquer comme mauvaise réponse",
        "Copied to clipboard.": "Copié dans le presse-papiers.",
        "Failed to copy to clipboard": "Échec de la copie dans le presse-papiers",
        "Save failed!": "Échec de l'enregistrement!",
        "Saved.": "Enregistré.",
        "Saved. Refresh the page for the changes to take effect.": "Enregistré. Actualisez la page pour que les modifications prennent effet.",
        "Session Deletion Failed!": "Échec de la suppression de la session!",
        "Tab Creation Failed!": "Échec de la création de l'onglet!",
        "Tab Created Successfully.": "Onglet créé avec succès.",
        "Failed to load the dashboard!": "Échec du chargement du tableau de bord!",
        "Failed to generate PDF": "Échec de la génération du PDF",
        "Sync completed.": "Synchronisation terminée.",
        "Refresh completed.": "Rafraîchissement terminé.",
        "Generating the summary. Please wait...": "Génération du résumé. Veuillez patienter...",
        "Unexpected error while exporting the summary.": "Erreur inattendue lors de l'export du résumé.",
        "Technical Details": "Détails techniques",
        "Copy": "Copier",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "Si votre prochaine question porte sur un sujet différent, pour de meilleurs résultats, commencez une nouvelle discussion en cliquant sur l'icône plus en haut.",
    },
    "de-DE": {
        "Add to Personal Dashboard": "Zum persönlichen Dashboard hinzufügen",
        "Visualize": "Visualisieren",
        "Share": "Teilen",
        "Modify": "Bearbeiten",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "Füge die Abfrage und das generierte SQL als neuen Testfall zu den Text-zu-SQL-Übersetzungstests hinzu",
        "Remove X-Axis Label": "X-Achsen-Beschriftung entfernen",
        "Remove Y-Axis Label": "Y-Achsen-Beschriftung entfernen",
        "Hide Values On Chart": "Werte im Diagramm ausblenden",
        "Rotate Labels 45°": "Beschriftungen um 45° drehen",
        "Hi! How can I help?": "Hallo! Wie kann ich helfen?",
        "Mark as Bad Response": "Als schlechte Antwort markieren",
        "Copied to clipboard.": "In die Zwischenablage kopiert.",
        "Failed to copy to clipboard": "Kopieren in die Zwischenablage fehlgeschlagen",
        "Save failed!": "Speichern fehlgeschlagen!",
        "Saved.": "Gespeichert.",
        "Saved. Refresh the page for the changes to take effect.": "Gespeichert. Aktualisieren Sie die Seite, damit die Änderungen wirksam werden.",
        "Session Deletion Failed!": "Sitzungslöschung fehlgeschlagen!",
        "Tab Creation Failed!": "Tab-Erstellung fehlgeschlagen!",
        "Tab Created Successfully.": "Tab erfolgreich erstellt.",
        "Failed to load the dashboard!": "Dashboard konnte nicht geladen werden!",
        "Failed to generate PDF": "PDF konnte nicht erstellt werden",
        "Sync completed.": "Synchronisierung abgeschlossen.",
        "Refresh completed.": "Aktualisierung abgeschlossen.",
        "Generating the summary. Please wait...": "Zusammenfassung wird erstellt. Bitte warten...",
        "Unexpected error while exporting the summary.": "Unerwarteter Fehler beim Exportieren der Zusammenfassung.",
        "Technical Details": "Technische Details",
        "Copy": "Kopieren",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "Wenn Ihre nächste Frage ein anderes Thema betrifft, starten Sie für die besten Ergebnisse einen neuen Chat, indem Sie oben auf das Plus-Symbol klicken.",
    },
    "hi-IN": {
        "Add to Personal Dashboard": "व्यक्तिगत डैशबोर्ड में जोड़ें",
        "Visualize": "दृश्य बनाएं",
        "Share": "साझा करें",
        "Modify": "संशोधित करें",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "Text-to-SQL अनुवाद परीक्षणों में क्वेरी और उत्पन्न SQL को एक नए परीक्षण मामले के रूप में जोड़ें",
        "Remove X-Axis Label": "X-अक्ष लेबल हटाएं",
        "Remove Y-Axis Label": "Y-अक्ष लेबल हटाएं",
        "Hide Values On Chart": "चार्ट पर मान छिपाएं",
        "Rotate Labels 45°": "लेबल को 45° घुमाएं",
        "Hi! How can I help?": "नमस्ते! मैं कैसे मदद कर सकता हूँ?",
        "Mark as Bad Response": "बुरी प्रतिक्रिया के रूप में चिह्नित करें",
        "Copied to clipboard.": "क्लिपबोर्ड पर कॉपी किया गया।",
        "Failed to copy to clipboard": "क्लिपबोर्ड पर कॉपी करने में विफल",
        "Save failed!": "सहेजना विफल रहा!",
        "Saved.": "सहेजा गया।",
        "Saved. Refresh the page for the changes to take effect.": "सहेजा गया। परिवर्तनों के लिए पृष्ठ को रीफ्रेश करें।",
        "Session Deletion Failed!": "सत्र हटाना विफल रहा!",
        "Tab Creation Failed!": "टैब बनाना विफल रहा!",
        "Tab Created Successfully.": "टैब सफलतापूर्वक बनाया गया।",
        "Failed to load the dashboard!": "डैशबोर्ड लोड करने में विफल!",
        "Failed to generate PDF": "PDF बनाने में विफल",
        "Sync completed.": "सिंक पूरा हुआ।",
        "Refresh completed.": "रीफ्रेश पूरा हुआ।",
        "Generating the summary. Please wait...": "सारांश तैयार किया जा रहा है। कृपया प्रतीक्षा करें...",
        "Unexpected error while exporting the summary.": "सारांश निर्यात करते समय अप्रत्याशित त्रुटि।",
        "Technical Details": "तकनीकी विवरण",
        "Copy": "कॉपी करें",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "यदि आपका अगला प्रश्न किसी अन्य विषय पर है, तो सर्वोत्तम परिणामों के लिए, शीर्ष पर प्लस आइकन पर क्लिक करके एक नई चैट शुरू करें।",
    },
    "ja-JP": {
        "Add to Personal Dashboard": "個人用ダッシュボードに追加",
        "Visualize": "可視化",
        "Share": "共有",
        "Modify": "修正",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "クエリと生成されたSQLをText-to-SQL翻訳テストの新しいテストケースとして追加する",
        "Remove X-Axis Label": "X軸ラベルを削除",
        "Remove Y-Axis Label": "Y軸ラベルを削除",
        "Hide Values On Chart": "チャート上の値を非表示",
        "Rotate Labels 45°": "ラベルを45°回転",
        "Hi! How can I help?": "こんにちは！どのようにお手伝いできますか？",
        "Mark as Bad Response": "悪い応答としてマーク",
        "Copied to clipboard.": "クリップボードにコピーしました。",
        "Failed to copy to clipboard": "クリップボードへのコピーに失敗しました",
        "Save failed!": "保存に失敗しました！",
        "Saved.": "保存しました。",
        "Saved. Refresh the page for the changes to take effect.": "保存しました。変更を反映するにはページを更新してください。",
        "Session Deletion Failed!": "セッションの削除に失敗しました！",
        "Tab Creation Failed!": "タブの作成に失敗しました！",
        "Tab Created Successfully.": "タブが正常に作成されました。",
        "Failed to load the dashboard!": "ダッシュボードの読み込みに失敗しました！",
        "Failed to generate PDF": "PDFの生成に失敗しました",
        "Sync completed.": "同期が完了しました。",
        "Refresh completed.": "更新が完了しました。",
        "Generating the summary. Please wait...": "要約を生成しています。しばらくお待ちください...",
        "Unexpected error while exporting the summary.": "要約のエクスポート中に予期しないエラーが発生しました。",
        "Technical Details": "技術的な詳細",
        "Copy": "コピー",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "次の質問が別のトピックに関する場合は、最良の結果を得るために、上部のプラスアイコンをクリックして新しいチャットを開始してください。",
    },
    "pt-BR": {
        "Add to Personal Dashboard": "Adicionar ao painel pessoal",
        "Visualize": "Visualizar",
        "Share": "Compartilhar",
        "Modify": "Modificar",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "Adicionar a consulta e o SQL gerado como um novo caso de teste nos testes de tradução Text-to-SQL",
        "Remove X-Axis Label": "Remover rótulo do eixo X",
        "Remove Y-Axis Label": "Remover rótulo do eixo Y",
        "Hide Values On Chart": "Ocultar valores no gráfico",
        "Rotate Labels 45°": "Girar rótulos 45°",
        "Hi! How can I help?": "Oi! Como posso ajudar?",
        "Mark as Bad Response": "Marcar como resposta ruim",
        "Copied to clipboard.": "Copiado para a área de transferência.",
        "Failed to copy to clipboard": "Falha ao copiar para a área de transferência",
        "Save failed!": "Falha ao salvar!",
        "Saved.": "Salvo.",
        "Saved. Refresh the page for the changes to take effect.": "Salvo. Atualize a página para que as alterações tenham efeito.",
        "Session Deletion Failed!": "Falha ao excluir a sessão!",
        "Tab Creation Failed!": "Falha ao criar a guia!",
        "Tab Created Successfully.": "Guia criada com sucesso.",
        "Failed to load the dashboard!": "Falha ao carregar o painel!",
        "Failed to generate PDF": "Falha ao gerar PDF",
        "Sync completed.": "Sincronização concluída.",
        "Refresh completed.": "Atualização concluída.",
        "Generating the summary. Please wait...": "Gerando o resumo. Por favor, aguarde...",
        "Unexpected error while exporting the summary.": "Erro inesperado ao exportar o resumo.",
        "Technical Details": "Detalhes técnicos",
        "Copy": "Copiar",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "Se sua próxima pergunta for sobre um tópico diferente, para obter os melhores resultados, inicie um novo chat clicando no ícone de mais na parte superior.",
    },
    "ru-RU": {
        "Add to Personal Dashboard": "Добавить на персональную панель",
        "Visualize": "Визуализировать",
        "Share": "Поделиться",
        "Modify": "Изменить",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "Добавить запрос и сгенерированный SQL как новый тестовый случай в тесты перевода Text-to-SQL",
        "Remove X-Axis Label": "Удалить метку оси X",
        "Remove Y-Axis Label": "Удалить метку оси Y",
        "Hide Values On Chart": "Скрыть значения на графике",
        "Rotate Labels 45°": "Повернуть метки на 45°",
        "Hi! How can I help?": "Привет! Как я могу помочь?",
        "Mark as Bad Response": "Отметить как плохой ответ",
        "Copied to clipboard.": "Скопировано в буфер обмена.",
        "Failed to copy to clipboard": "Не удалось скопировать в буфер обмена",
        "Save failed!": "Ошибка сохранения!",
        "Saved.": "Сохранено.",
        "Saved. Refresh the page for the changes to take effect.": "Сохранено. Обновите страницу, чтобы изменения вступили в силу.",
        "Session Deletion Failed!": "Ошибка удаления сессии!",
        "Tab Creation Failed!": "Ошибка создания вкладки!",
        "Tab Created Successfully.": "Вкладка успешно создана.",
        "Failed to load the dashboard!": "Не удалось загрузить панель!",
        "Failed to generate PDF": "Не удалось создать PDF",
        "Sync completed.": "Синхронизация завершена.",
        "Refresh completed.": "Обновление завершено.",
        "Generating the summary. Please wait...": "Генерируется сводка. Пожалуйста, подождите...",
        "Unexpected error while exporting the summary.": "Неожиданная ошибка при экспорте сводки.",
        "Technical Details": "Технические детали",
        "Copy": "Копировать",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "Если ваш следующий вопрос на другую тему, для достижения наилучших результатов начните новый чат, нажав на значок плюса вверху.",
    },
    "es-ES": {
        "Add to Personal Dashboard": "Agregar al panel personal",
        "Visualize": "Visualizar",
        "Share": "Compartir",
        "Modify": "Modificar",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "Agregar la consulta и el SQL generado como un nuevo caso de prueba a las pruebas de traducción Text-to-SQL",
        "Remove X-Axis Label": "Eliminar etiqueta del eje X",
        "Remove Y-Axis Label": "Eliminar etiqueta del eje Y",
        "Hide Values On Chart": "Ocultar valores en el gráfico",
        "Rotate Labels 45°": "Rotar etiquetas 45°",
        "Hi! How can I help?": "¡Hola! ¿Cómo puedo ayudar?",
        "Mark as Bad Response": "Marcar como respuesta mala",
        "Copied to clipboard.": "Copiado al portapapeles.",
        "Failed to copy to clipboard": "Error al copiar al portapapeles",
        "Save failed!": "¡Error al guardar!",
        "Saved.": "Guardado.",
        "Saved. Refresh the page for the changes to take effect.": "Guardado. Actualiza la página para que los cambios tengan efecto.",
        "Session Deletion Failed!": "¡Error al eliminar la sesión!",
        "Tab Creation Failed!": "¡Error al crear la pestaña!",
        "Tab Created Successfully.": "Pestaña creada con éxito.",
        "Failed to load the dashboard!": "¡Error al cargar el panel!",
        "Failed to generate PDF": "Error al generar el PDF",
        "Sync completed.": "Sincronización completada.",
        "Refresh completed.": "Actualización completada.",
        "Generating the summary. Please wait...": "Generando el resumen. Por favor, espere...",
        "Unexpected error while exporting the summary.": "Error inesperado al exportar el resumen.",
        "Technical Details": "Detalles técnicos",
        "Copy": "Copiar",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "Si su próxima pregunta es sobre un tema diferente, para obtener los mejores resultados, inicie un nuevo chat haciendo clic en el ícono de más en la parte superior.",
    },
    "ar-SA": {
        "Add to Personal Dashboard": "أضف إلى لوحة المعلومات الشخصية",
        "Visualize": "تصور",
        "Share": "مشاركة",
        "Modify": "تعديل",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "أضف الاستعلام وSQL المُولّد كحالة اختبار جديدة لاختبارات ترجمة Text-to-SQL",
        "Remove X-Axis Label": "إزالة تسمية المحور السيني",
        "Remove Y-Axis Label": "إزالة تسمية المحور الصادي",
        "Hide Values On Chart": "إخفاء القيم على الرسم البياني",
        "Rotate Labels 45°": "تدوير الملصقات 45 درجة",
        "Hi! How can I help?": "مرحبًا! كيف يمكنني المساعدة؟",
        "Mark as Bad Response": "وضع علامة على الاستجابة السيئة",
        "Copied to clipboard.": "تم النسخ إلى الحافظة",
        "Failed to copy to clipboard": "فشل النسخ إلى الحافظة",
        "Save failed!": "فشل الحفظ",
        "Saved.": "تم الحفظ",
        "Saved. Refresh the page for the changes to take effect.": "تم الحفظ. يرجى تحديث الصفحة لتطبيق التغييرات",
        "Session Deletion Failed!": "فشل حذف الجلسة",
        "Tab Creation Failed!": "فشل إنشاء التبويب",
        "Tab Created Successfully.": "تم إنشاء التبويب بنجاح",
        "Failed to load the dashboard!": "فشل تحميل لوحة المعلومات",
        "Failed to generate PDF": "فشل إنشاء ملف PDF",
        "Sync completed.": "اكتمل المزامنة.",
        "Refresh completed.": "اكتمل التحديث.",
        "Generating the summary. Please wait...": "يتم الآن إنشاء الملخص. يرجى الانتظار...",
        "Unexpected error while exporting the summary.": "حدث خطأ غير متوقع أثناء تصدير الملخص.",
        "Technical Details": "تفاصيل تقنية",
        "Copy": "نسخ",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "إذا كان سؤالك التالي حول موضوع مختلف، للحصول على أفضل النتائج، ابدأ محادثة جديدة بالنقر على أيقونة الزائد في الأعلى.",
    },
    "fa-IR": {
        "Add to Personal Dashboard": "افزودن به داشبورد شخصی",
        "Visualize": "رسم نمودار",
        "Share": "به اشتراک گذاری",
        "Modify": "ایجاد تغییرات",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "اضافه کردن سوال و کد تولید شده به عنوان یک مورد آزمایشی جدید به آزمون های ترجمه Text-to-SQL",
        "Remove X-Axis Label": "حذف برچسب محور افقی",
        "Remove Y-Axis Label": "حذف برچسب محور عمودی",
        "Hide Values On Chart": "مخفی کردن مقادیر روی نمودار",
        "Rotate Labels 45°": "چرخش برچسب ها به اندازه 45 درجه",
        "Hi! How can I help?": "سلام! چطور می توانم کمک کنم؟",
        "Mark as Bad Response": "علامت گذاری به عنوان پاسخ بد",
        "Copied to clipboard.": "در کلیپ‌بورد کپی شد",
        "Failed to copy to clipboard": "کپی در کلیپ‌بورد ناموفق بود",
        "Save failed!": "ذخیره‌سازی ناموفق بود",
        "Saved.": "ذخیره شد",
        "Saved. Refresh the page for the changes to take effect.": "ذخیره شد. برای اعمال تغییرات صفحه را ریفرش کنید",
        "Session Deletion Failed!": "حذف ناموفق بود",
        "Tab Creation Failed!": "ایجاد تب ناموفق بود",
        "Tab Created Successfully.": "تب با موفقیت ایجاد شد",
        "Failed to load the dashboard!": "بارگذاری داشبورد ناموفق بود",
        "Failed to generate PDF": "تولید PDF ناموفق بود",
        "Sync completed.": "همگام‌سازی تکمیل شد.",
        "Refresh completed.": "به‌روزرسانی تکمیل شد.",
        "Generating the summary. Please wait...": "در حال تولید خلاصه. لطفاً صبر کنید...",
        "Unexpected error while exporting the summary.": "خطای غیرمنتظره هنگام تولید خلاصه.",
        "Technical Details": "جزئیات فنی",
        "Copy": "کپی",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "اگر سوال بعدی شما در مورد موضوع دیگری است، برای بهترین نتیجه، با کلیک روی نماد مثبت در بالا، یک گفتگوی جدید را شروع کنید.",
    },
    "zh-CN": {
        "Add to Personal Dashboard": "添加到个人仪表板",
        "Visualize": "可视化",
        "Share": "分享",
        "Modify": "修改",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "将查询和生成的SQL作为新的测试用例添加到Text-to-SQL翻译测试中",
        "Remove X-Axis Label": "删除X轴标签",
        "Remove Y-Axis Label": "删除Y轴标签",
        "Hide Values On Chart": "隐藏图表上的值",
        "Rotate Labels 45°": "旋转标签45°",
        "Hi! How can I help?": "嗨！我能帮你什么？",
        "Mark as Bad Response": "标记为不良响应",
        "Copied to clipboard.": "已复制到剪贴板。",
        "Failed to copy to clipboard": "复制到剪贴板失败",
        "Save failed!": "保存失败！",
        "Saved.": "已保存。",
        "Saved. Refresh the page for the changes to take effect.": "已保存。请刷新页面以使更改生效。",
        "Session Deletion Failed!": "会话删除失败！",
        "Tab Creation Failed!": "标签创建失败！",
        "Tab Created Successfully.": "标签创建成功。",
        "Failed to load the dashboard!": "仪表板加载失败！",
        "Failed to generate PDF": "生成PDF失败",
        "Sync completed.": "同步完成。",
        "Refresh completed.": "刷新完成。",
        "Generating the summary. Please wait...": "正在生成摘要。请稍候...",
        "Unexpected error while exporting the summary.": "导出摘要时发生意外错误。",
        "Technical Details": "技术细节",
        "Copy": "复制",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "如果您的下一个问题是关于不同主题的，为获得最佳结果，请点击顶部的加号图标开始新的聊天。",
    },
    "zh-TW": {
        "Add to Personal Dashboard": "新增至個人儀表板",
        "Visualize": "視覺化",
        "Share": "分享",
        "Modify": "修改",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "將查詢與產生的SQL作為新的測試案例新增至Text-to-SQL翻譯測試中",
        "Remove X-Axis Label": "移除X軸標籤",
        "Remove Y-Axis Label": "移除Y軸標籤",
        "Hide Values On Chart": "隱藏圖表上的值",
        "Rotate Labels 45°": "旋轉標籤45°",
        "Hi! How can I help?": "嗨！我能幫助你什麼？",
        "Mark as Bad Response": "標記為不良回應",
        "Copied to clipboard.": "已複製到剪貼簿。",
        "Failed to copy to clipboard": "複製到剪貼簿失敗",
        "Save failed!": "儲存失敗！",
        "Saved.": "已儲存。",
        "Saved. Refresh the page for the changes to take effect.": "已儲存。請重新整理頁面以套用變更。",
        "Session Deletion Failed!": "刪除會話失敗！",
        "Tab Creation Failed!": "建立分頁失敗！",
        "Tab Created Successfully.": "分頁建立成功。",
        "Failed to load the dashboard!": "儀表板載入失敗！",
        "Failed to generate PDF": "產生PDF失敗",
        "Sync completed.": "同步完成。",
        "Refresh completed.": "重新整理完成。",
        "Generating the summary. Please wait...": "正在生成摘要。請稍候...",
        "Unexpected error while exporting the summary.": "匯出摘要時發生非預期錯誤。",
        "Technical Details": "技術細節",
        "Copy": "複製",
    },
    "bn-BD": {
        "Add to Personal Dashboard": "ব্যক্তিগত ড্যাশবোর্ডে যোগ করুন",
        "Visualize": "চিত্রায়িত করুন",
        "Share": "শেয়ার করুন",
        "Modify": "পরিবর্তন করুন",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "Text-to-SQL অনুবাদ পরীক্ষায় একটি নতুন টেস্ট কেস হিসাবে কুয়েরি এবং তৈরি করা SQL যুক্ত করুন",
        "Remove X-Axis Label": "X-অক্ষের লেবেল সরান",
        "Remove Y-Axis Label": "Y-অক্ষের লেবেল সরান",
        "Hide Values On Chart": "চার্টে মান লুকান",
        "Rotate Labels 45°": "লেবেল 45° ঘোরান",
        "Hi! How can I help?": "হ্যালো! আমি কিভাবে সাহায্য করতে পারি?",
        "Mark as Bad Response": "খারাপ প্রতিক্রিয়া হিসাবে চিহ্নিত করুন",
        "Copied to clipboard.": "ক্লিপবোর্ডে কপি হয়েছে।",
        "Failed to copy to clipboard": "ক্লিপবোর্ডে কপি করতে ব্যর্থ",
        "Save failed!": "সংরক্ষণ ব্যর্থ হয়েছে!",
        "Saved.": "সংরক্ষিত হয়েছে।",
        "Saved. Refresh the page for the changes to take effect.": "সংরক্ষিত হয়েছে। পরিবর্তন কার্যকর করতে পৃষ্ঠা রিফ্রেশ করুন।",
        "Session Deletion Failed!": "সেশন মুছে ফেলা ব্যর্থ হয়েছে!",
        "Tab Creation Failed!": "ট্যাব তৈরি ব্যর্থ হয়েছে!",
        "Tab Created Successfully.": "ট্যাব সফলভাবে তৈরি হয়েছে।",
        "Failed to load the dashboard!": "ড্যাশবোর্ড লোড করতে ব্যর্থ!",
        "Failed to generate PDF": "PDF তৈরি ব্যর্থ হয়েছে",
        "Sync completed.": "সিঙ্ক সম্পন্ন হয়েছে।",
        "Refresh completed.": "রিফ্রেশ সম্পন্ন হয়েছে।",
        "Generating the summary. Please wait...": "সারাংশ তৈরি হচ্ছে। অনুগ্রহ করে অপেক্ষা করুন...",
        "Unexpected error while exporting the summary.": "সারাংশ রপ্তানি করার সময় অপ্রত্যাশিত ত্রুটি।",
        "Technical Details": "প্রযুক্তিগত বিবরণ",
        "Copy": "কপি করুন",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "যদি আপনার পরবর্তী প্রশ্নটি ভিন্ন বিষয়ে হয়, সর্বোত্তম ফলাফলের জন্য, উপরে প্লাস আইকনে ক্লিক করে একটি নতুন চ্যাট শুরু করুন।",
    },
    "he-IL": {
        "Add to Personal Dashboard": "הוסף ללוח מחוונים אישי",
        "Visualize": "ויזואליזציה",
        "Share": "שתף",
        "Modify": "שנה",
        "Add the query and the generated SQL as a new test case to the Text-to-SQL translation tests": "הוסף את השאילתה ואת ה-SQL שנוצרו כמקרה בדיקה חדש לבדיקות תרגום Text-to-SQL",
        "Remove X-Axis Label": "הסר תווית ציר X",
        "Remove Y-Axis Label": "הסר תווית ציר Y",
        "Hide Values On Chart": "הסתר ערכים בגרף",
        "Rotate Labels 45°": "סובב תוויות 45°",
        "Hi! How can I help?": "שלום! איך אני יכול לעזור?",
        "Mark as Bad Response": "סמן כתשובה רעה",
        "Copied to clipboard.": "הועתק ללוח",
        "Failed to copy to clipboard": "ההעתקה ללוח נכשלה",
        "Save failed!": "השמירה נכשלה",
        "Saved.": "נשמר",
        "Saved. Refresh the page for the changes to take effect.": "נשמר. רענן את הדף כדי שהשינויים ייכנסו לתוקף",
        "Session Deletion Failed!": "מחיקת הסשן נכשלה",
        "Tab Creation Failed!": "יצירת הלשונית נכשלה",
        "Tab Created Successfully.": "הלשונית נוצרה בהצלחה",
        "Failed to load the dashboard!": "טעינת לוח המחוונים נכשלה",
        "Failed to generate PDF": "יצירת PDF נכשלה",
        "Sync completed.": "סנכרון הושלם.",
        "Refresh completed.": "רענון הושלם.",
        "Generating the summary. Please wait...": "יוצר את הסיכום. נא להמתין...",
        "Unexpected error while exporting the summary.": "שגיאה בלתי צפויה בעת ייצוא הסיכום.",
        "Technical Details": "פרטים טכניים",
        "Copy": "העתק",
        "If your next question is on a different topic, for the best results, start a new chat by clicking the plus icon at the top.": "אם השאלה הבאה שלך עוסקת בנושא אחר, לקבלת התוצאות הטובות ביותר, התחל צ'אט חדש על ידי לחיצה על סמל הפלוס למעלה.",
    }
};


function get_translation(key, locale = 'en-US') {
    return translations[locale]?.[key] || key;
}
