@echo off

:: Save original dir and switch to db folder
set ORIG_DIR=%CD%
cd /d "%~dp0"

set PGROOT=%CD%
set PGDATA=%PGROOT%\data
set PATH=%PGROOT%\bin;%PATH%

if not exist "%PGDATA%\PG_VERSION" (
    echo Initializing PostgreSQL data directory...
    bin\initdb -U postgres -A trust -E UTF8 -D "%PGDATA%"
)

:: Start PostgreSQL (ignore if already running)
bin\pg_ctl -D "%PGDATA%" -o "-p 5432" -l "%PGROOT%\logfile.txt" start

:: Wait for it to start
timeout /T 2 > nul

:: Create database if not exists
psql -U postgres -p 5432 -h 127.0.0.1 -tc "SELECT 1 FROM pg_database WHERE datname='databot';" | find "1" >nul
if errorlevel 1 (
    echo Creating database 'databot'...
    bin\createdb -U postgres -p 5432 -h 127.0.0.1 databot
)

:: Restore original dir
cd /d "%ORIG_DIR%"